using System;
using DarkStrideToolbox;


namespace DarkStride.StellarLanes.Server
{
	public class FileServerUpdater
	{
		#region Properties
		private const long m_cFILESERVERPORT = 8701;
		private DSFileServer m_oFileServer = null;

		private const string m_cDISTROTEXT = ".distrib";

		private structFile[] m_oaFiles = null;

		private struct structFile
		{
			private string m_sPath;
			private string m_sVersionLastChanged;

			public string Path
			{
				get
				{
					return( m_sPath );
				}
				set
				{
					m_sPath = value;
				}
			}			
			public string VersionLastChanged
			{
				get
				{
					return( m_sVersionLastChanged );
				}
				set
				{
					m_sVersionLastChanged = value;
				}
			}
		}

		#endregion


		public FileServerUpdater()
		{
			//string sPath = Environment.CurrentDirectory + @"\ClientUpdates\";
			string sPath = Environment.CurrentDirectory + @"\";
			//string sPath = DSMisc.GetDevelopmentAppPath();


			m_oaFiles = new structFile[ 8 ];

            //We copy them so that we don't lock them during debugging.  
            if (System.Diagnostics.Debugger.IsAttached == true)
            {
                System.IO.File.Copy(sPath + "..\\..\\..\\ClientEXE\\bin\\Debug\\StellarLanesClient.exe", sPath + "StellarLanesClient.exe",true);
                System.IO.File.Copy(sPath + @"..\\..\\..\\DSIntro.gob", sPath + "DSIntro.gob", true);
                System.IO.File.Copy(sPath + @"..\\..\\..\\StellarLanes.gob", sPath + "StellarLanes.gob", true);
                System.IO.File.Copy(sPath + "..\\..\\..\\ClientEXE\\bin\\Debug\\Recoil.exe", sPath + "Recoil.exe", true);
                System.IO.File.Copy(sPath + "..\\..\\..\\ShipBuilder\\bin\\Debug\\ShipBuilder.exe", sPath + "ShipBuilder.exe", true);
            }

            m_oaFiles[0].Path = sPath + "StellarLanesClient.exe";
            //m_oaFiles[ 0 ].VersionLastChanged = "1.0.3.0";

            m_oaFiles[1].Path = sPath + "DarkStrideToolbox.dll";
            //m_oaFiles[ 1 ].VersionLastChanged = "1.0.3.0";

            m_oaFiles[2].Path = sPath + "StellarLanes.dll";
            //m_oaFiles[ 2 ].VersionLastChanged = "1.0.3.0";

            m_oaFiles[3].Path = sPath + @"DSIntro.gob";
            //m_oaFiles[ 3 ].VersionLastChanged = "1.0.3.0";

            m_oaFiles[4].Path = sPath + "StellarLanes.gob";
            //m_oaFiles[ 4 ].VersionLastChanged = "1.0.3.0";

            m_oaFiles[5].Path = sPath + "Recoil.exe";
            //m_oaFiles[ 5 ].VersionLastChanged = "1.0.1.0";

			m_oaFiles[ 6 ].Path = sPath + "StellarLanesServer.exe";
			//m_oaFiles[ 6 ].VersionLastChanged = "1.0.1.0";

            m_oaFiles[7].Path = sPath + "ShipBuilder.exe";
            //m_oaFiles[ 7 ].VersionLastChanged = "1.0.1.0";
		}

		public void HostFileVersionServer()
		{
			//Host our file for anyone who happens to be behind
			m_oFileServer = new DSFileServer();
			//m_oFileServer.FileTransferUpdate += new EventHandler( this.TransferUpdate );
			m_oFileServer.StartFileServer( m_cFILESERVERPORT );

			/*//First make a copy of our files
			for( int i=0 ; i<m_oaFiles.Length ; i++ )
			{
				System.IO.File.Copy( m_oaFiles[i].Path,m_oaFiles[i].Path + m_cDISTROTEXT, true);
			}*/

			//Host files
			for( int i=0 ; i<m_oaFiles.Length ; i++ )
			{
				m_oFileServer.HostFile( m_oaFiles[i].Path,// + m_cDISTROTEXT,
							System.IO.Path.GetFileName( m_oaFiles[i].Path ),
							System.IO.Path.GetFileNameWithoutExtension( m_oaFiles[i].Path ) + " binary for Stellar Lanes." );
				
			}
		}
		public string[] GetFilesNeedingUpdateFrom( string sVersionToCheck )
		{
			string sCurVer = "1.0.50";
			string[] saFilesNeedingUpdates = new string[ m_oaFiles.Length ];

			//03/29/2007 Chris Hill  New product really.
			if( sVersionToCheck.Substring( 0,sCurVer.Length ) != sCurVer )
			{
				for( int i=0 ; i<m_oaFiles.Length ; i++ )
				{
					saFilesNeedingUpdates[ i ] = m_oaFiles[ i ].Path;
				}
			}

			return( saFilesNeedingUpdates );
		}
	}
}
